/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableList;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.workerbuildings.IBuildingPublicCrafter;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.client.gui.huts.WindowHutWorkerModulePlaceholder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingFurnaceUser;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingWorkerView;
import com.minecolonies.coremod.colony.jobs.JobDyer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingDyer
extends AbstractBuildingFurnaceUser
implements IBuildingPublicCrafter {
    private static final String DYER = "dyer";
    private static final String DYER_SMELTING = "dyer_smelting";

    public BuildingDyer(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return DYER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobDyer(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return DYER;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Creativity;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Dexterity;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.dyer;
    }

    @Override
    public Skill getCraftSpeedSkill() {
        return this.getSecondarySkill();
    }

    public static class SmeltingModule
    extends AbstractCraftingBuildingModule.Smelting {
        @Override
        @Nullable
        public IJob<?> getCraftingJob() {
            return this.getMainBuildingJob().orElseGet(() -> new JobDyer(null));
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            return CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, BuildingDyer.DYER_SMELTING).orElse(false);
        }
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        @Override
        @Nullable
        public IJob<?> getCraftingJob() {
            return this.getMainBuildingJob().orElseGet(() -> new JobDyer(null));
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            return CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, BuildingDyer.DYER).orElse(false);
        }

        @Override
        public IRecipeStorage getFirstRecipe(Predicate<ItemStack> stackPredicate) {
            IRecipeStorage recipe = super.getFirstRecipe(stackPredicate);
            if (recipe == null && stackPredicate.test(new ItemStack((IItemProvider)Items.field_221603_aE))) {
                HashMap<ItemStorage, Integer> inventoryCounts = new HashMap<ItemStorage, Integer>();
                if (!this.building.getColony().getBuildingManager().hasWarehouse()) {
                    return null;
                }
                List woolItems = ItemTags.field_199904_a.func_230236_b_().stream().filter(item -> !item.equals(Items.field_221603_aE)).map(i -> new ItemStorage(new ItemStack((IItemProvider)i))).collect(Collectors.toList());
                for (ItemStorage color : woolItems) {
                    for (IBuilding iBuilding : this.building.getColony().getBuildingManager().getWareHouses()) {
                        int colorCount = InventoryUtils.getCountFromBuilding(iBuilding, color);
                        inventoryCounts.put(color, inventoryCounts.getOrDefault(color, 0) + colorCount);
                    }
                }
                ItemStorage woolToUse = (ItemStorage)inventoryCounts.entrySet().stream().min(Map.Entry.comparingByValue(Comparator.reverseOrder())).get().getKey();
                IRecipeStorage tempRecipe = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{ImmutableList.of((Object)woolToUse, (Object)new ItemStorage(new ItemStack((IItemProvider)Items.field_222069_lA, 1))), 1, new ItemStack((IItemProvider)Items.field_221603_aE, 1), Blocks.field_150350_a});
                IToken<?> token = IColonyManager.getInstance().getRecipeManager().checkOrAddRecipe(tempRecipe);
                recipe = IColonyManager.getInstance().getRecipeManager().getRecipe(token);
            }
            return recipe;
        }

        @Override
        public boolean holdsRecipe(IToken<?> token) {
            if (super.holdsRecipe(token)) {
                return true;
            }
            return IColonyManager.getInstance().getRecipeManager().getRecipe(token).getPrimaryOutput().func_77973_b() == Items.field_221603_aE;
        }
    }

    public static class View
    extends AbstractBuildingWorkerView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerModulePlaceholder<View>(this, BuildingDyer.DYER);
        }
    }
}

